<?php

namespace wpautoterms\admin\page;

use wpautoterms\admin\Notices;
use wpautoterms\admin\Options;
use wpautoterms\cpt\CPT;
use wpautoterms\Frontend;
use wpautoterms\option\Checkbox_Option;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Settings_Page_Advanced extends Settings_Base {
	public function define_options() {
		parent::define_options();
		$cache_reminder = __( 'Clean/delete cache after enabling or disabling this option.', WPAUTOTERMS_SLUG );
		$s = array(
			__( 'Enable this option only if you experience problems with the notification banners. Most popular caching plugins should handle the notification banners properly with this option disabled.',
				WPAUTOTERMS_SLUG )
		);
		if ( Options::get_option( Options::CACHE_PLUGINS_DETECTED ) ) {
			$s[] = __( '<strong>Unsupported caching plugins detected. We recommend enabling this option.</strong>', 'auto-terms-of-service-and-privacy-policy' );
		}
		$s[] = $cache_reminder;
		if ( count( $s ) == 2 ) {
			$cache_hint_format = _x( '%s<br/>%s', 'Cache hint format', WPAUTOTERMS_SLUG );
		} else {
			$cache_hint_format = _x( '%s<br/>%s<br/>%s', 'Cache hint format', WPAUTOTERMS_SLUG );
		}
		array_unshift( $s, $cache_hint_format );
		$compat_hint = call_user_func_array( 'sprintf', $s );
		new Checkbox_Option( Options::CACHE_PLUGINS_COMPAT, __( 'Caching plugins compatibility mode', WPAUTOTERMS_SLUG ),
			$compat_hint, $this->id(), static::SECTION_ID );
	}

	public function render() {
		parent::render();
		Notices::$instance->delete_persistent( Notices::CLASS_ERROR, Frontend::CACHE_PLUGIN_NOTICE_ID );
		if ( Options::get_option( Options::CACHE_PLUGINS_COMPAT ) ) {
			Options::set_option( Options::CACHE_PLUGINS_DETECTION, false );
		}
	}

	public function defaults() {
		return array_reduce( array(
			Options::CACHE_PLUGINS_COMPAT
		), function ( $acc, $x ) {
			$acc[ $x ] = Options::default_value( $x );

			return $acc;
		}, array() );
	}

	public function register_menu() {
		$page_title = $this->title();
		$menu_title = '';
		$page_id = $this->id();
		
		// Ensure all parameters are valid strings
		$page_title = is_string($page_title) && !empty($page_title) ? $page_title : 'Advanced Settings';
		$page_id = is_string($page_id) && !empty($page_id) ? $page_id : '';
		
		if (empty($page_id)) {
			return;
		}
		
		add_submenu_page( '',
			$page_title,
			$menu_title,
			CPT::edit_cap(),
			$page_id,
			array( $this, 'render' )
		);
	}

	public function enqueue_scripts() {
		parent::enqueue_scripts(); // TODO: Change the autogenerated stub
		wp_enqueue_script( WPAUTOTERMS_SLUG . 'admin_settings_advanced', WPAUTOTERMS_PLUGIN_URL . 'js/admin-settings-advanced.js',[], WPAUTOTERMS_VERSION, true );
	}
}
